/*
 * Decompiled with CFR 0.152.
 */
package program;

import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import java.io.IOException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import program.TrasnferType;

public class DownloadWindow
extends Application {
    @FXML
    private ProgressIndicator progressBar;
    @FXML
    private Label nameLabel;
    @FXML
    private Label typeLabel;
    private String fileName;
    private TrasnferType type;
    private FTPClient client;
    private Stage stage;
    private Image appImg = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/resources/icons/AEGIS_logo.png"));

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/AEGIS_Download.fxml"));
        loader.setController((Object)this);
        Parent root = null;
        try {
            root = (Parent)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nameLabel.setText(this.fileName);
        Scene scene = new Scene(root, 300.0, 275.0);
        if (this.type == TrasnferType.DOWNLOAD) {
            stage.setTitle("Downloading file...");
        } else {
            stage.setTitle("Uploading file...");
            this.typeLabel.setText("Uploading");
        }
        stage.setScene(scene);
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                DownloadWindow.this.abort();
            }
        });
        stage.getIcons().add((Object)this.appImg);
        stage.show();
    }

    public DownloadWindow(String fileName, TrasnferType type, FTPClient client) {
        this.client = client;
        this.fileName = fileName;
        this.type = type;
        try {
            this.start(new Stage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProgress(final double prog) {
        if (this.progressBar.getProgress() < prog) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DownloadWindow.this.progressBar.setProgress(prog);
                }
            });
        }
    }

    public void refresh() {
    }

    @FXML
    public void abort() {
        if (this.progressBar.getProgress() != 1.0) {
            try {
                this.client.abortCurrentDataTransfer(true);
            }
            catch (FTPIllegalReplyException | IOException e) {
                System.out.println("ERROR: Cannot abort current data transfer connection!");
            }
        }
        this.stage.close();
    }
}

