/*
 * Decompiled with CFR 0.152.
 */
package program;

import it.sauronsoftware.ftp4j.FTPAbortedException;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPDataTransferException;
import it.sauronsoftware.ftp4j.FTPException;
import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import it.sauronsoftware.ftp4j.FTPListParseException;
import it.sauronsoftware.ftp4j.FTPReply;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import program.Main;
import program.MyFTPFile;
import program.MyFTPListener;
import program.TrasnferType;
import settings.Settings;

public class FTPOperator {
    private String serverIP;
    private String userName;
    private String password;
    private String root;
    private Main main;
    private StandardPBEStringEncryptor encryptor;
    private FTPClient ftpClient = null;
    private TreeView<MyFTPFile> folderStructure;
    private TreeItem<MyFTPFile> rootNode;
    private Image folderImg = new Image(this.getClass().getResourceAsStream("/resources/icons/folder.png"));
    private Image audioImg = new Image(this.getClass().getResourceAsStream("/resources/icons/audio.png"));
    private Image videoImg = new Image(this.getClass().getResourceAsStream("/resources/icons/video.png"));
    private Image imageImg = new Image(this.getClass().getResourceAsStream("/resources/icons/image.png"));
    private Image fileImg = new Image(this.getClass().getResourceAsStream("/resources/icons/file.png"));
    private Image documentImg = new Image(this.getClass().getResourceAsStream("/resources/icons/document.png"));
    private Image codeImg = new Image(this.getClass().getResourceAsStream("/resources/icons/code.png"));
    private Image archiveImg = new Image(this.getClass().getResourceAsStream("/resources/icons/archive.png"));
    private final String downloadsPath = String.valueOf(System.getProperty("user.home")) + "/Downloads/";

    public FTPOperator(Properties defaultConfig, Main main, TreeView<MyFTPFile> folderStructure) {
        this.main = main;
        this.folderStructure = folderStructure;
        this.encryptor = new StandardPBEStringEncryptor();
        this.encryptor.setPassword(Settings.cryptKey);
        this.ftpClient = this.getAdjustedFtp();
        if (!defaultConfig.isEmpty()) {
            this.loadDefault(defaultConfig);
        }
    }

    private FTPClient getAdjustedFtp() {
        FTPClient ftp = new FTPClient();
        ftp.setMLSDPolicy(2);
        ftp.getConnector().setConnectionTimeout(60);
        ftp.getConnector().setReadTimeout(60);
        ftp.setType(2);
        ftp.setAutoNoopTimeout(60000L);
        return ftp;
    }

    public void loadDefault(Properties defaultConfig) {
        this.disconnect(false);
        this.serverIP = defaultConfig.getProperty("server");
        this.userName = defaultConfig.getProperty("user");
        this.password = this.encryptor.decrypt(defaultConfig.getProperty("pass"));
        this.root = defaultConfig.getProperty("root");
        MyFTPFile rootItem = new MyFTPFile();
        rootItem.setName(this.root);
        rootItem.setType(1);
        rootItem.setSize(-1L);
        rootItem.setLink(this.root);
        this.rootNode = new TreeItem((Object)rootItem);
        this.connect();
    }

    public void connect() {
        if (this.serverIP != null) {
            Thread thread = new Thread("Server connector"){

                @Override
                public void run() {
                    try {
                        if (FTPOperator.this.ftpClient.isConnected()) {
                            FTPOperator.this.ftpClient.disconnect(true);
                        }
                        FTPOperator.this.main.prepareBgVideo("bigload");
                        FTPOperator.this.ftpClient.connect(FTPOperator.this.serverIP, 21);
                        FTPOperator.this.ftpClient.login(FTPOperator.this.userName, FTPOperator.this.password);
                        if (FTPOperator.this.ftpClient.isConnected()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    FTPOperator.this.folderStructure.setVisible(true);
                                    FTPOperator.this.rootNode.setExpanded(true);
                                    FTPOperator.this.folderStructure.setRoot(FTPOperator.this.rootNode);
                                }
                            });
                            FTPOperator.this.loadFiles();
                        } else {
                            System.err.println("ERROR: Could not connect to the server!");
                        }
                    }
                    catch (FTPException | FTPIllegalReplyException | IOException | IllegalStateException e) {
                        if (FTPOperator.this.ftpClient.isConnected()) {
                            try {
                                FTPOperator.this.ftpClient.disconnect(false);
                            }
                            catch (FTPException | FTPIllegalReplyException | IOException | IllegalStateException e1) {
                                e1.printStackTrace();
                            }
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FTPOperator.this.main.playSound("contact_failed.mp3");
                                FTPOperator.this.main.prepareBgVideo("offline");
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                                stage.getIcons().add((Object)((FTPOperator)(this).FTPOperator.this).main.appImg);
                                alert.setTitle("Server connection error!");
                                alert.setHeaderText("ERROR: Could not connect to the server!");
                                alert.setContentText("Defailed description here: " + e.getMessage());
                                alert.showAndWait();
                            }
                        });
                    }
                }
            };
            thread.start();
        }
    }

    public void loadFiles() {
        if (this.ftpClient.isConnected()) {
            Thread thread = new Thread("Server loader"){

                @Override
                public void run() {
                    FTPOperator.this.main.prepareBgVideo("load");
                    try {
                        TreeItem item;
                        if (((MyFTPFile)FTPOperator.this.rootNode.getValue()).getName().equals("/Lima Whiskey/")) {
                            FTPOperator.this.main.playSound("server_lima.mp3");
                        } else if (((MyFTPFile)FTPOperator.this.rootNode.getValue()).getName().equals("/Virgil/")) {
                            FTPOperator.this.main.playSound("server_virgil.mp3");
                        } else if (((MyFTPFile)FTPOperator.this.rootNode.getValue()).getName().equals(FTPOperator.this.root)) {
                            FTPOperator.this.main.playSound("server_online.mp3");
                        }
                        FTPOperator.this.ftpClient.changeDirectory(((MyFTPFile)FTPOperator.this.rootNode.getValue()).getLink());
                        FTPFile[] list = FTPOperator.this.ftpClient.list();
                        Object[] files = new MyFTPFile[list.length];
                        int i = 0;
                        while (i < list.length) {
                            FTPFile file = list[i];
                            MyFTPFile myFile = new MyFTPFile();
                            if (file.getType() == 1) {
                                myFile.setLink(String.valueOf(((MyFTPFile)FTPOperator.this.rootNode.getValue()).getLink()) + file.getName() + "/");
                            } else {
                                myFile.setLink(String.valueOf(((MyFTPFile)FTPOperator.this.rootNode.getValue()).getLink()) + file.getName());
                            }
                            myFile.setModifiedDate(file.getModifiedDate());
                            myFile.setName(file.getName());
                            myFile.setSize(file.getSize());
                            myFile.setType(file.getType());
                            files[i] = myFile;
                            ++i;
                        }
                        Arrays.sort(files);
                        Object[] objectArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object file = objectArray[n2];
                            if (((FTPFile)file).getType() == 1) {
                                item = new TreeItem(file);
                                item.setGraphic((Node)new ImageView(FTPOperator.this.folderImg));
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        FTPOperator.this.rootNode.getChildren().add((Object)item);
                                    }
                                });
                            }
                            ++n2;
                        }
                        objectArray = files;
                        n = files.length;
                        n2 = 0;
                        while (n2 < n) {
                            Object file = objectArray[n2];
                            if (((FTPFile)file).getType() == 0) {
                                item = new TreeItem(file);
                                item.setGraphic((Node)new ImageView(FTPOperator.this.assignIcon((MyFTPFile)file)));
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        FTPOperator.this.rootNode.getChildren().add((Object)item);
                                    }
                                });
                            }
                            ++n2;
                        }
                        FTPOperator.this.main.prepareBgVideo("online");
                    }
                    catch (FTPAbortedException | FTPDataTransferException | FTPException | FTPIllegalReplyException | FTPListParseException | IOException | IllegalStateException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FTPOperator.this.main.playSound("error.mp3");
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                                stage.getIcons().add((Object)((FTPOperator)(this).FTPOperator.this).main.appImg);
                                alert.setTitle("File loading error!");
                                alert.setHeaderText("ERROR: Exception during loading files!");
                                alert.setContentText("Defailed description here: " + e.getMessage());
                                alert.showAndWait();
                                FTPOperator.this.main.prepareBgVideo("offline");
                            }
                        });
                    }
                }
            };
            thread.start();
        }
    }

    private Image assignIcon(MyFTPFile file) {
        String s;
        String fileType = file.getName().substring(file.getName().lastIndexOf(46));
        String[] music = new String[]{".mp3", ".aac", ".flac", ".m4a", ".ogg", ".wav", ".wma", ".amr"};
        String[] video = new String[]{".webm", ".mkv", ".flv", ".vob", ".ogv", ".avi", ".wmv", ".mov", ".amv", ".mp4", ".mpg", ".mpeg", ".m4v", ".3gp"};
        String[] image = new String[]{".bmp", ".gif", ".jpeg", ".jpg", ".png", ".tiff"};
        String[] document = new String[]{".xls", ".xlsx", ".doc", ".docx", ".pdf", ".rtf", ".odt", ".txt"};
        String[] code = new String[]{".c", ".cs", ".java", ".html", ".php", ".a", ".asm", ".bat", ".cpp", ".dll", ".h", ".o", ".s", ".sbl", ".sh"};
        String[] archive = new String[]{".zip", ".jar", ".rar", ".uha", ".iso"};
        String[] stringArray = music;
        int n = music.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.audioImg;
            }
            ++n2;
        }
        stringArray = video;
        n = video.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.videoImg;
            }
            ++n2;
        }
        stringArray = image;
        n = image.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.imageImg;
            }
            ++n2;
        }
        stringArray = document;
        n = document.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.documentImg;
            }
            ++n2;
        }
        stringArray = code;
        n = code.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.codeImg;
            }
            ++n2;
        }
        stringArray = archive;
        n = archive.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(fileType)) {
                return this.archiveImg;
            }
            ++n2;
        }
        return this.fileImg;
    }

    public void downloadFile(final MyFTPFile selected) {
        Thread thread = new Thread("Server download"){

            @Override
            public void run() {
                try {
                    File downloads = new File(FTPOperator.this.downloadsPath);
                    if (!downloads.exists()) {
                        downloads.mkdir();
                    }
                    FTPClient dwnFtpClient = FTPOperator.this.getAdjustedFtp();
                    dwnFtpClient.connect(FTPOperator.this.serverIP, 21);
                    dwnFtpClient.login(FTPOperator.this.userName, FTPOperator.this.password);
                    long size = dwnFtpClient.fileSize(selected.getLink());
                    dwnFtpClient.download(selected.getLink(), new File(String.valueOf(FTPOperator.this.downloadsPath) + selected.getName()), new MyFTPListener(size, selected.getName(), TrasnferType.DOWNLOAD, dwnFtpClient));
                    dwnFtpClient.disconnect(true);
                }
                catch (FTPAbortedException downloads) {
                }
                catch (FTPDataTransferException | FTPException | FTPIllegalReplyException | IOException | IllegalStateException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FTPOperator.this.main.playSound("error.mp3");
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                            stage.getIcons().add((Object)((FTPOperator)(this).FTPOperator.this).main.appImg);
                            alert.setTitle("Downloading error!");
                            alert.setHeaderText("ERROR: Exception during downloading file!");
                            alert.setContentText("Defailed description here: " + e.getMessage());
                            alert.showAndWait();
                        }
                    });
                }
            }
        };
        thread.start();
    }

    public void uploadFile(final File file) {
        Thread thread = new Thread("Server upload"){

            @Override
            public void run() {
                try {
                    FTPClient uplFtpClient = FTPOperator.this.getAdjustedFtp();
                    uplFtpClient.connect(FTPOperator.this.serverIP, 21);
                    uplFtpClient.login(FTPOperator.this.userName, FTPOperator.this.password);
                    long size = file.length();
                    uplFtpClient.changeDirectory(((MyFTPFile)FTPOperator.this.rootNode.getValue()).getLink());
                    if (!FTPOperator.this.checkPermissions()) {
                        throw new SecurityException("Checking permission: Permission denied.");
                    }
                    uplFtpClient.upload(file, new MyFTPListener(size, file.getName(), TrasnferType.UPLOAD, uplFtpClient));
                    uplFtpClient.disconnect(true);
                    FTPOperator.this.rootNode.getChildren().clear();
                    FTPOperator.this.loadFiles();
                }
                catch (FTPAbortedException uplFtpClient) {
                }
                catch (FTPDataTransferException | FTPException | FTPIllegalReplyException | IOException | IllegalStateException | SecurityException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FTPOperator.this.ftpClient.abortCurrentDataTransfer(true);
                            }
                            catch (FTPIllegalReplyException | IOException e1) {
                                System.err.println("ERROR: Cannot kill current data transfer!");
                            }
                            if (e.getMessage().substring(e.getMessage().lastIndexOf(":") + 2).equals("Permission denied.")) {
                                FTPOperator.this.main.playSound("security_error.mp3");
                            }
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                            stage.getIcons().add((Object)((FTPOperator)(this).FTPOperator.this).main.appImg);
                            alert.setTitle("Uploading error!");
                            alert.setHeaderText("ERROR: Exception during uploading file!");
                            alert.setContentText("Defailed description here: " + e.getMessage());
                            alert.showAndWait();
                        }
                    });
                }
            }
        };
        thread.start();
    }

    private boolean checkPermissions() {
        try {
            FTPReply reply = this.ftpClient.sendCustomCommand("MLST");
            if (reply.getCode() == 250) {
                int index = reply.getMessages()[1].lastIndexOf("UNIX.mode=") + 11;
                String[] nums = reply.getMessages()[1].substring(index, index + 3).split("");
                StringBuilder sb = new StringBuilder();
                String[] stringArray = nums;
                int n = nums.length;
                int n2 = 0;
                while (n2 < n) {
                    int num;
                    String s = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(((num = Integer.parseInt(s)) & 4) == 0 ? (char)'-' : 'r');
                    sb.append((num & 2) == 0 ? (char)'-' : 'w');
                    sb.append((num & 1) == 0 ? (char)'-' : 'x');
                    ++n2;
                }
                return sb.toString().contains("w");
            }
            return true;
        }
        catch (FTPIllegalReplyException | IOException | IllegalStateException e) {
            System.err.println("ERROR: While checking write permissions!");
            System.err.println("Detailed description here: " + e.getMessage());
            return true;
        }
    }

    public void setRoot(TreeItem<MyFTPFile> rootNode) {
        this.rootNode = rootNode;
    }

    public void disconnect(boolean permanent) {
        try {
            if (this.ftpClient.isConnected()) {
                this.ftpClient.disconnect(true);
                if (this.rootNode != null && permanent) {
                    this.main.playSound("status_offline.mp3");
                }
            }
        }
        catch (FTPException | FTPIllegalReplyException | IOException | IllegalStateException e) {
            System.err.println("ERROR: Cannot disconnect from the server!");
        }
        this.rootNode = null;
        this.folderStructure.setRoot(null);
        this.folderStructure.setVisible(false);
    }
}

