/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import program.FTPOperator;
import program.MyFTPFile;
import settings.Settings;

public class Main
extends Application {
    private FTPOperator ftpOperator = null;
    private TreeView<MyFTPFile> folderStructure;
    private MediaPlayer player = null;
    private MediaView bgVideo = null;
    private MediaPlayer soundPlayer = null;
    private boolean sounds = true;
    private boolean animations = true;
    private String currentVideo = null;
    public final Image appImg = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/resources/icons/AEGIS_logo.png"));

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public void start(final Stage primaryStage) throws Exception {
        primaryStage.setTitle("AEGIS 2.0  Beta 1.71");
        this.folderStructure = new TreeView();
        this.folderStructure.setOnMouseClicked(e -> this.treeViewClick((MouseEvent)e));
        this.folderStructure.setPrefWidth(500.0);
        this.folderStructure.setLayoutX(10.0);
        this.folderStructure.setLayoutY(10.0);
        this.folderStructure.setVisible(false);
        StackPane root = new StackPane();
        root.setStyle("-fx-background-color: #000000");
        final Pane panel = new Pane();
        panel.getChildren().addAll((Object[])new Node[]{this.folderStructure});
        this.folderStructure.getParent().layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldVale, Bounds newValue) {
                Main.this.folderStructure.setPrefHeight(newValue.getHeight() - 20.0);
            }
        });
        this.folderStructure.setOnKeyTyped((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent arg0) {
                TreeItem parent;
                TreeItem selected = (TreeItem)Main.this.folderStructure.getSelectionModel().getSelectedItem();
                if (selected != null && (parent = ((TreeItem)Main.this.folderStructure.getSelectionModel().getSelectedItem()).getParent()) != null) {
                    TreeItem possible;
                    String s = arg0.getCharacter();
                    ObservableList items = parent.getChildren();
                    if (((MyFTPFile)selected.getValue()).getName().toLowerCase().startsWith(s) && (possible = (TreeItem)items.get(items.indexOf((Object)selected) + 1)) != null && ((MyFTPFile)possible.getValue()).getName().toLowerCase().startsWith(s)) {
                        Main.this.folderStructure.getSelectionModel().select((Object)possible);
                        Main.this.folderStructure.scrollTo(Main.this.folderStructure.getRow(possible));
                        return;
                    }
                    for (TreeItem it : items) {
                        if (!((MyFTPFile)it.getValue()).getName().toLowerCase().startsWith(s)) continue;
                        Main.this.folderStructure.getSelectionModel().select((Object)it);
                        Main.this.folderStructure.scrollTo(Main.this.folderStructure.getRow(it));
                        break;
                    }
                }
            }
        });
        this.bgVideo = new MediaView();
        this.bgVideo.setPreserveRatio(false);
        this.prepareBgVideo("offline");
        root.getChildren().add((Object)this.bgVideo);
        root.getChildren().add((Object)panel);
        this.bgVideo.setFitHeight(this.bgVideo.getParent().getBoundsInParent().getHeight());
        this.bgVideo.setFitWidth(this.bgVideo.getParent().getBoundsInParent().getWidth());
        this.bgVideo.getParent().layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                Main.this.bgVideo.setFitHeight(newValue.getHeight());
                Main.this.bgVideo.setFitWidth(newValue.getWidth());
            }
        });
        this.ftpOperator = new FTPOperator(this.loadDefault(), this, this.folderStructure);
        MenuItem settingsItem = new MenuItem("Settings");
        settingsItem.setOnAction(e -> {
            Settings settings = new Settings(new Stage(), this.ftpOperator, this);
        });
        MenuItem refreshItem = new MenuItem("Refresh Video");
        refreshItem.setOnAction(e -> this.prepareBgVideo(this.currentVideo));
        MenuItem connectDefaultItem = new MenuItem("Connect Default");
        connectDefaultItem.setOnAction(e -> this.ftpOperator.loadDefault(this.loadDefault()));
        MenuItem disconnectItem = new MenuItem("Disconnect");
        disconnectItem.setOnAction(e -> this.disconnectOperation());
        final ContextMenu contextMenu = new ContextMenu(new MenuItem[]{settingsItem, refreshItem, connectDefaultItem, disconnectItem});
        MenuItem downloadItem = new MenuItem("Download");
        downloadItem.setOnAction(e -> this.downloadFile());
        MenuItem uploadItem = new MenuItem("Upload here");
        uploadItem.setOnAction(e -> this.uploadFileHere());
        MenuItem uploadInsideItem = new MenuItem("Upload inside");
        uploadInsideItem.setOnAction(e -> this.uploadFileInside());
        final ContextMenu ctx = new ContextMenu(new MenuItem[]{downloadItem, uploadItem, uploadInsideItem});
        panel.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent e) {
                if (e.getTarget().equals(panel)) {
                    contextMenu.show((Window)primaryStage, e.getScreenX(), e.getScreenY());
                } else {
                    ctx.show((Window)primaryStage, e.getScreenX(), e.getScreenY());
                }
            }
        });
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                Main.this.ftpOperator.disconnect(false);
            }
        });
        primaryStage.getIcons().add((Object)this.appImg);
        primaryStage.setScene(new Scene((Parent)root));
        primaryStage.setMaximized(true);
        primaryStage.show();
        this.playSound("activating.mp3");
    }

    public void playSound(String fileName) {
        if (this.sounds) {
            try {
                this.soundPlayer = new MediaPlayer(new Media(Main.class.getResource("/resources/voice/" + fileName).toURI().toString()));
                this.soundPlayer.setOnReady(new Runnable(){

                    @Override
                    public void run() {
                        Main.this.soundPlayer.play();
                    }
                });
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public void prepareBgVideo(String type) {
        this.currentVideo = type;
        String fileName = null;
        if (type.equals("load")) {
            fileName = "aegis-loading.mp4";
        } else if (type.equals("online")) {
            fileName = "aegis-online.mp4";
        } else if (type.equals("offline")) {
            fileName = "aegis-offline.mp4";
        } else if (type.equals("bigload")) {
            fileName = "aegis-loading-screen.mp4";
        }
        try {
            this.player = new MediaPlayer(new Media(Main.class.getResource("/resources/" + fileName).toURI().toString()));
        }
        catch (URISyntaxException e) {
            System.err.println("ERROR: Media player cannot start!");
        }
        this.bgVideo.setMediaPlayer(this.player);
        if (this.animations) {
            this.player.setOnReady(new Runnable(){

                @Override
                public void run() {
                    Main.this.player.setOnEndOfMedia(new Runnable(){

                        @Override
                        public void run() {
                            Main.this.player.seek(Duration.ZERO);
                        }
                    });
                    Main.this.player.play();
                }
            });
        } else {
            this.player.setOnReady(new Runnable(){

                @Override
                public void run() {
                    Main.this.player.play();
                    Main.this.player.pause();
                }
            });
        }
    }

    public Properties loadDefault() {
        Properties defaultConfig = new Properties();
        Properties prop = new Properties();
        File defaultConfigFile = new File("./conf/defaultConfig.properties");
        if (defaultConfigFile.exists()) {
            try {
                File config;
                FileInputStream fis = new FileInputStream(defaultConfigFile);
                prop.load(fis);
                boolean tmpAnimations = this.animations;
                boolean tmpSounds = this.sounds;
                this.sounds = prop.getProperty("sounds").equals("true");
                boolean bl = this.animations = prop.getProperty("animations").equals("true");
                if (!tmpAnimations && this.animations) {
                    this.player.play();
                }
                if (tmpAnimations && !this.animations) {
                    if (this.player.getCurrentTime().toSeconds() < 1.0) {
                        this.player.setOnReady(new Runnable(){

                            @Override
                            public void run() {
                                Main.this.player.seek(Duration.ZERO);
                                Main.this.player.pause();
                            }
                        });
                    } else {
                        this.player.seek(Duration.ZERO);
                        this.player.pause();
                    }
                }
                if (tmpSounds && !this.sounds) {
                    this.sounds = true;
                    this.playSound("deactivate_voice.mp3");
                    this.sounds = false;
                }
                if (!prop.getProperty("defaultConfig").equals("") && (config = new File("./conf/" + prop.getProperty("defaultConfig"))).exists()) {
                    FileInputStream fis2 = new FileInputStream(config);
                    defaultConfig.load(fis2);
                    fis2.close();
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("ERROR: File not found while loading old config!");
            }
            catch (IOException e) {
                System.err.println("ERROR: IO Exception while loading old config!");
            }
        }
        return defaultConfig;
    }

    private void treeViewClick(MouseEvent e) {
        TreeItem item = (TreeItem)this.folderStructure.getSelectionModel().getSelectedItem();
        if (e.getClickCount() > 1 && item.getChildren().size() == 0 && ((MyFTPFile)item.getValue()).getType() == 1) {
            this.ftpOperator.setRoot((TreeItem<MyFTPFile>)item);
            this.ftpOperator.loadFiles();
            item.setExpanded(true);
        } else if (e.getClickCount() > 1 && ((MyFTPFile)item.getValue()).getType() != 1) {
            this.downloadFile();
        }
    }

    private void downloadFile() {
        TreeItem item = (TreeItem)this.folderStructure.getSelectionModel().getSelectedItem();
        if (item != null) {
            if (((MyFTPFile)item.getValue()).getType() == 0) {
                this.ftpOperator.downloadFile((MyFTPFile)item.getValue());
            } else {
                this.playSound("error.mp3");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)this.appImg);
                alert.setTitle("Downloading error!");
                alert.setHeaderText("ERROR: Exception during downloading file!");
                alert.setContentText("Selected file is directory!");
                alert.showAndWait();
            }
        }
    }

    private void uploadFileHere() {
        TreeItem selected = (TreeItem)this.folderStructure.getSelectionModel().getSelectedItem();
        if (selected != null) {
            TreeItem parent = selected.getParent();
            if (parent != null) {
                this.uploadFile((TreeItem<MyFTPFile>)selected, (TreeItem<MyFTPFile>)parent);
            } else {
                this.playSound("error.mp3");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)this.appImg);
                alert.setTitle("Uploading error!");
                alert.setHeaderText("ERROR: Exception during uploading file!");
                alert.setContentText("You have to click INSIDE folder!");
                alert.showAndWait();
            }
        }
    }

    private void uploadFileInside() {
        TreeItem selected = (TreeItem)this.folderStructure.getSelectionModel().getSelectedItem();
        if (selected != null) {
            if (((MyFTPFile)selected.getValue()).getType() == 1) {
                this.uploadFile((TreeItem<MyFTPFile>)selected, (TreeItem<MyFTPFile>)selected);
            } else {
                this.playSound("error.mp3");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)this.appImg);
                alert.setTitle("Uploading error!");
                alert.setHeaderText("ERROR: Exception during uploading file!");
                alert.setContentText("Selected item is not directory!");
                alert.showAndWait();
            }
        }
    }

    private void uploadFile(TreeItem<MyFTPFile> selected, TreeItem<MyFTPFile> uploadTo) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Resource File");
        File file = fileChooser.showOpenDialog((Window)new Stage());
        if (file != null) {
            if (!file.isDirectory()) {
                this.ftpOperator.setRoot(uploadTo);
                this.ftpOperator.uploadFile(file);
            } else {
                this.playSound("error.mp3");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)this.appImg);
                alert.setTitle("Uploading error!");
                alert.setHeaderText("ERROR: Exception during uploading file!");
                alert.setContentText("Selected file is directory!");
                alert.showAndWait();
            }
        }
    }

    private void disconnectOperation() {
        this.ftpOperator.disconnect(true);
        this.prepareBgVideo("offline");
    }
}

